/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include "mx_auto_config.h"
#include "myriexpress.h"

#define PROC1_EID 1
#define PROC2_EID 2
#define FILTER 0x54321
#define MATCH_VAL 0xabcdef

char Hostname[256];

mx_return_t
test_mx()
{
  mx_return_t rc;
  mx_endpoint_t ep;

  rc = mx_init();
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "test_mx: mx_init: %s\n", mx_strerror(rc));
    return rc;
  }

  rc = mx_open_endpoint(MX_ANY_NIC, PROC2_EID, FILTER, NULL, 0, &ep);
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "test_mx: mx_open_endpoint: %s\n", mx_strerror(rc));
    return rc;
  }

  rc = mx_close_endpoint(ep);
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "test_mx: mx_close_endpoint: %s\n", mx_strerror(rc));
    return rc;
  }

  rc = mx_finalize();
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "test_mx: mx_finalize: %s\n", mx_strerror(rc));
    return rc;
  }

  return MX_SUCCESS;
}

void
proc1()
{
  mx_return_t rc;
  mx_endpoint_t ep;

  rc = mx_init();
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "proc1: mx_init: %s\n", mx_strerror(rc));
    exit(1);
  }

  rc = mx_open_endpoint(MX_ANY_NIC, PROC1_EID, FILTER, NULL, 0, &ep);
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "proc1: mx_open_endpoint: %s\n", mx_strerror(rc));
    exit(1);
  }

  while (1) {
    sleep(10);
  }
}

void
proc2()
{
  mx_return_t rc;
  mx_endpoint_t ep;
  uint64_t his_nic_id;
  mx_endpoint_addr_t his_addr;
  mx_segment_t seg[1];
  mx_request_t req;
  mx_status_t stat;
  uint32_t result;

  rc = mx_init();
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "proc2: mx_init: %s\n", mx_strerror(rc));
    exit(1);
  }

  rc = mx_open_endpoint(MX_ANY_NIC, PROC2_EID, FILTER, NULL, 0, &ep);
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "proc2: mx_open_endpoint: %s\n", mx_strerror(rc));
    exit(1);
  }

  rc = mx_hostname_to_nic_id(Hostname, &his_nic_id);
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "proc2: mx_hostname_to_nic_id: %s\n", mx_strerror(rc));
    exit(1);
  }

  rc = mx_connect(ep, his_nic_id, PROC1_EID, FILTER, MX_INFINITE, &his_addr);
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "proc2: mx_connect: %s\n", mx_strerror(rc));
    exit(1);
  }

  /* build something to send */
  seg[0].segment_ptr = Hostname;
  seg[0].segment_length = sizeof(Hostname);

  rc = mx_issend(ep, seg, 1, his_addr, MATCH_VAL, NULL, &req);
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "proc2: mx_isend: %s\n", mx_strerror(rc));
    exit(1);
  }

  while (1) {
    rc = mx_test(ep, &req, &stat, &result);
    if ((rc == MX_SUCCESS) && (result == 1)) {
      fprintf(stderr, "proc2: mx_test succeeded??\n");
      exit(1);

    } else if (rc != MX_SUCCESS) {
      fprintf(stderr, "proc2: mx_test: %s\n", mx_strerror(rc));
      exit(1);
    }
  }
}


int main(int argc, char **argv)
{
  pid_t p1;
  pid_t p2;
  pid_t pid;
  int stat;
  mx_return_t rc;

  mx_set_error_handler(MX_ERRORS_RETURN);
  /* get our hostname */
  gethostname(Hostname, sizeof(Hostname));
  strcat(Hostname,":0");

  p1 = fork();
  if (p1 == 0) {
    proc1();
  }
  sleep(1);

  p2 = fork();
  if (p2 == 0) {
    proc2();
  }

  /* wait a bit, then infanticide... */
  sleep(5);
  kill(p1, 9);
  kill(p2, 9);

  pid = waitpid(p1, &stat, 0);
  if (pid != p1) {
    perror("waitpid 1");
    exit(1);
  }
  if (stat != 9) {
    fprintf(stderr, "proc 1 exited funny\n");
    exit(1);
  }

  pid = waitpid(p2, &stat, 0);
  if (pid != p2) {
    perror("waitpid 2");
    exit(1);
  }
  if (stat != 9) {
    fprintf(stderr, "proc 1 exited funny\n");
    exit(1);
  }

  /* OK, now see if we can open an endpoint */
  rc = test_mx();

  exit((rc == MX_SUCCESS) ? 0 : 1);
}
